/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class ElementInternals {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SetFormValueStateUnionType {
    @JsOverlay
    static ElementInternals.SetFormValueStateUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default File asFile() {
      return Js.cast(this);
    }

    @JsOverlay
    default FormData asFormData() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isFile() {
      return (Object) this instanceof File;
    }

    @JsOverlay
    default boolean isFormData() {
      return (Object) this instanceof FormData;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SetFormValueValueUnionType {
    @JsOverlay
    static ElementInternals.SetFormValueValueUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default File asFile() {
      return Js.cast(this);
    }

    @JsOverlay
    default FormData asFormData() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isFile() {
      return (Object) this instanceof File;
    }

    @JsOverlay
    default boolean isFormData() {
      return (Object) this instanceof FormData;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public HTMLFormElement form;
  public NodeList<HTMLLabelElement> labels;
  public ShadowRoot shadowRoot;
  public String validationMessage;
  public ValidityState validity;
  public boolean willValidate;

  public native boolean checkValidity();

  public native boolean reportValidity();

  @JsOverlay
  public final Object setFormValue(File value, File state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(File value, FormData state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(File value, ElementInternals.SetFormValueStateUnionType state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value), state);
  }

  @JsOverlay
  public final Object setFormValue(File value, String state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(FormData value, File state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(FormData value, FormData state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(
      FormData value, ElementInternals.SetFormValueStateUnionType state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value), state);
  }

  @JsOverlay
  public final Object setFormValue(FormData value, String state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(ElementInternals.SetFormValueValueUnionType value, File state) {
    return setFormValue(
        value, Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(
      ElementInternals.SetFormValueValueUnionType value, FormData state) {
    return setFormValue(
        value, Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  public native Object setFormValue(
      ElementInternals.SetFormValueValueUnionType value,
      ElementInternals.SetFormValueStateUnionType state);

  @JsOverlay
  public final Object setFormValue(
      ElementInternals.SetFormValueValueUnionType value, String state) {
    return setFormValue(
        value, Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(String value, File state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(String value, FormData state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  @JsOverlay
  public final Object setFormValue(
      String value, ElementInternals.SetFormValueStateUnionType state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value), state);
  }

  @JsOverlay
  public final Object setFormValue(String value, String state) {
    return setFormValue(
        Js.<ElementInternals.SetFormValueValueUnionType>uncheckedCast(value),
        Js.<ElementInternals.SetFormValueStateUnionType>uncheckedCast(state));
  }

  public native Object setValidity(ValidityStateFlags flags, String message, HTMLElement anchor);
}
