/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fr" locale.
 */
public class LocalizedNamesImpl_fr extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "FR",
        "DE",
        "GB",
        "CM",
        "MG",
        "CA",
        "CI",
        "TN",
        "DZ",
        "NL",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CV",
        "EA",
        "CL",
        "CN",
        "CY",
        "CO",
        "KM",
        "CG",
        "CD",
        "KP",
        "KR",
        "CR",
        "CI",
        "HR",
        "CU",
        "CW",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EG",
        "AE",
        "EC",
        "ER",
        "ES",
        "EE",
        "VA",
        "FM",
        "US",
        "ET",
        "FJ",
        "FI",
        "FR",
        "GA",
        "GM",
        "GE",
        "GS",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HU",
        "BV",
        "CX",
        "CP",
        "AC",
        "IM",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "HM",
        "FK",
        "MP",
        "MH",
        "UM",
        "PN",
        "SB",
        "TC",
        "VG",
        "VI",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "RE",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "UN",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "UG",
        "UZ",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "NL",
        "BQ",
        "PE",
        "PH",
        "PL",
        "PF",
        "PR",
        "PT",
        "QA",
        "HK",
        "MO",
        "QO",
        "CF",
        "DO",
        "RO",
        "GB",
        "RU",
        "RW",
        "EH",
        "BL",
        "KN",
        "SH",
        "LC",
        "SM",
        "MF",
        "SX",
        "PM",
        "VC",
        "SV",
        "WS",
        "AS",
        "ST",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SK",
        "SI",
        "SO",
        "SD",
        "SS",
        "LK",
        "SE",
        "CH",
        "SR",
        "SJ",
        "SZ",
        "SY",
        "TJ",
        "TW",
        "TZ",
        "TD",
        "CZ",
        "TF",
        "IO",
        "PS",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "EU",
        "UY",
        "VU",
        "VE",
        "VN",
        "WF",
        "XA",
        "XB",
        "YE",
        "ZM",
        "ZW",
        "EZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Monde");
    namesMap.put("002", "Afrique");
    namesMap.put("003", "Amérique du Nord");
    namesMap.put("005", "Amérique du Sud");
    namesMap.put("009", "Océanie");
    namesMap.put("011", "Afrique occidentale");
    namesMap.put("013", "Amérique centrale");
    namesMap.put("014", "Afrique orientale");
    namesMap.put("015", "Afrique septentrionale");
    namesMap.put("017", "Afrique centrale");
    namesMap.put("018", "Afrique australe");
    namesMap.put("019", "Amériques");
    namesMap.put("021", "Amérique septentrionale");
    namesMap.put("029", "Caraïbes");
    namesMap.put("030", "Asie de l’Est");
    namesMap.put("034", "Asie du Sud");
    namesMap.put("035", "Asie du Sud-Est");
    namesMap.put("039", "Europe du Sud");
    namesMap.put("053", "Australasie");
    namesMap.put("054", "Mélanésie");
    namesMap.put("057", "région micronésienne");
    namesMap.put("061", "Polynésie");
    namesMap.put("142", "Asie");
    namesMap.put("143", "Asie centrale");
    namesMap.put("145", "Asie de l’Ouest");
    namesMap.put("151", "Europe de l’Est");
    namesMap.put("154", "Europe du Nord");
    namesMap.put("155", "Europe de l’Ouest");
    namesMap.put("202", "Afrique subsaharienne");
    namesMap.put("419", "Amérique latine");
    namesMap.put("AC", "Île de l’Ascension");
    namesMap.put("AD", "Andorre");
    namesMap.put("AE", "Émirats arabes unis");
    namesMap.put("AG", "Antigua-et-Barbuda");
    namesMap.put("AL", "Albanie");
    namesMap.put("AM", "Arménie");
    namesMap.put("AQ", "Antarctique");
    namesMap.put("AR", "Argentine");
    namesMap.put("AS", "Samoa américaines");
    namesMap.put("AT", "Autriche");
    namesMap.put("AU", "Australie");
    namesMap.put("AX", "Îles Åland");
    namesMap.put("AZ", "Azerbaïdjan");
    namesMap.put("BA", "Bosnie-Herzégovine");
    namesMap.put("BB", "Barbade");
    namesMap.put("BE", "Belgique");
    namesMap.put("BG", "Bulgarie");
    namesMap.put("BH", "Bahreïn");
    namesMap.put("BJ", "Bénin");
    namesMap.put("BL", "Saint-Barthélemy");
    namesMap.put("BM", "Bermudes");
    namesMap.put("BN", "Brunéi Darussalam");
    namesMap.put("BO", "Bolivie");
    namesMap.put("BQ", "Pays-Bas caribéens");
    namesMap.put("BR", "Brésil");
    namesMap.put("BT", "Bhoutan");
    namesMap.put("BV", "Île Bouvet");
    namesMap.put("BY", "Biélorussie");
    namesMap.put("CC", "Îles Cocos");
    namesMap.put("CD", "Congo-Kinshasa");
    namesMap.put("CF", "République centrafricaine");
    namesMap.put("CG", "Congo-Brazzaville");
    namesMap.put("CH", "Suisse");
    namesMap.put("CK", "Îles Cook");
    namesMap.put("CL", "Chili");
    namesMap.put("CM", "Cameroun");
    namesMap.put("CN", "Chine");
    namesMap.put("CO", "Colombie");
    namesMap.put("CP", "Île Clipperton");
    namesMap.put("CV", "Cap-Vert");
    namesMap.put("CX", "Île Christmas");
    namesMap.put("CY", "Chypre");
    namesMap.put("CZ", "Tchéquie");
    namesMap.put("DE", "Allemagne");
    namesMap.put("DK", "Danemark");
    namesMap.put("DM", "Dominique");
    namesMap.put("DO", "République dominicaine");
    namesMap.put("DZ", "Algérie");
    namesMap.put("EA", "Ceuta et Melilla");
    namesMap.put("EC", "Équateur");
    namesMap.put("EE", "Estonie");
    namesMap.put("EG", "Égypte");
    namesMap.put("EH", "Sahara occidental");
    namesMap.put("ER", "Érythrée");
    namesMap.put("ES", "Espagne");
    namesMap.put("ET", "Éthiopie");
    namesMap.put("EU", "Union européenne");
    namesMap.put("EZ", "zone euro");
    namesMap.put("FI", "Finlande");
    namesMap.put("FJ", "Fidji");
    namesMap.put("FK", "Îles Malouines");
    namesMap.put("FM", "États fédérés de Micronésie");
    namesMap.put("FO", "Îles Féroé");
    namesMap.put("GB", "Royaume-Uni");
    namesMap.put("GD", "Grenade");
    namesMap.put("GE", "Géorgie");
    namesMap.put("GF", "Guyane française");
    namesMap.put("GG", "Guernesey");
    namesMap.put("GL", "Groenland");
    namesMap.put("GM", "Gambie");
    namesMap.put("GN", "Guinée");
    namesMap.put("GQ", "Guinée équatoriale");
    namesMap.put("GR", "Grèce");
    namesMap.put("GS", "Géorgie du Sud et îles Sandwich du Sud");
    namesMap.put("GW", "Guinée-Bissau");
    namesMap.put("HK", "R.A.S. chinoise de Hong Kong");
    namesMap.put("HM", "Îles Heard et McDonald");
    namesMap.put("HR", "Croatie");
    namesMap.put("HT", "Haïti");
    namesMap.put("HU", "Hongrie");
    namesMap.put("IC", "Îles Canaries");
    namesMap.put("ID", "Indonésie");
    namesMap.put("IE", "Irlande");
    namesMap.put("IL", "Israël");
    namesMap.put("IM", "Île de Man");
    namesMap.put("IN", "Inde");
    namesMap.put("IO", "Territoire britannique de l’océan Indien");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islande");
    namesMap.put("IT", "Italie");
    namesMap.put("JM", "Jamaïque");
    namesMap.put("JO", "Jordanie");
    namesMap.put("JP", "Japon");
    namesMap.put("KG", "Kirghizistan");
    namesMap.put("KH", "Cambodge");
    namesMap.put("KM", "Comores");
    namesMap.put("KN", "Saint-Christophe-et-Niévès");
    namesMap.put("KP", "Corée du Nord");
    namesMap.put("KR", "Corée du Sud");
    namesMap.put("KW", "Koweït");
    namesMap.put("KY", "Îles Caïmans");
    namesMap.put("LB", "Liban");
    namesMap.put("LC", "Sainte-Lucie");
    namesMap.put("LR", "Libéria");
    namesMap.put("LT", "Lituanie");
    namesMap.put("LV", "Lettonie");
    namesMap.put("LY", "Libye");
    namesMap.put("MA", "Maroc");
    namesMap.put("MD", "Moldavie");
    namesMap.put("ME", "Monténégro");
    namesMap.put("MF", "Saint-Martin");
    namesMap.put("MH", "Îles Marshall");
    namesMap.put("MK", "Macédoine");
    namesMap.put("MM", "Myanmar (Birmanie)");
    namesMap.put("MN", "Mongolie");
    namesMap.put("MO", "R.A.S. chinoise de Macao");
    namesMap.put("MP", "Îles Mariannes du Nord");
    namesMap.put("MR", "Mauritanie");
    namesMap.put("MT", "Malte");
    namesMap.put("MU", "Maurice");
    namesMap.put("MX", "Mexique");
    namesMap.put("MY", "Malaisie");
    namesMap.put("NA", "Namibie");
    namesMap.put("NC", "Nouvelle-Calédonie");
    namesMap.put("NF", "Île Norfolk");
    namesMap.put("NG", "Nigéria");
    namesMap.put("NL", "Pays-Bas");
    namesMap.put("NO", "Norvège");
    namesMap.put("NP", "Népal");
    namesMap.put("NZ", "Nouvelle-Zélande");
    namesMap.put("PE", "Pérou");
    namesMap.put("PF", "Polynésie française");
    namesMap.put("PG", "Papouasie-Nouvelle-Guinée");
    namesMap.put("PL", "Pologne");
    namesMap.put("PM", "Saint-Pierre-et-Miquelon");
    namesMap.put("PN", "Îles Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Territoires palestiniens");
    namesMap.put("PW", "Palaos");
    namesMap.put("QO", "régions éloignées de l’Océanie");
    namesMap.put("RE", "La Réunion");
    namesMap.put("RO", "Roumanie");
    namesMap.put("RS", "Serbie");
    namesMap.put("RU", "Russie");
    namesMap.put("SA", "Arabie saoudite");
    namesMap.put("SB", "Îles Salomon");
    namesMap.put("SD", "Soudan");
    namesMap.put("SE", "Suède");
    namesMap.put("SG", "Singapour");
    namesMap.put("SH", "Sainte-Hélène");
    namesMap.put("SI", "Slovénie");
    namesMap.put("SJ", "Svalbard et Jan Mayen");
    namesMap.put("SK", "Slovaquie");
    namesMap.put("SM", "Saint-Marin");
    namesMap.put("SN", "Sénégal");
    namesMap.put("SO", "Somalie");
    namesMap.put("SS", "Soudan du Sud");
    namesMap.put("ST", "Sao Tomé-et-Principe");
    namesMap.put("SV", "Salvador");
    namesMap.put("SX", "Saint-Martin (partie néerlandaise)");
    namesMap.put("SY", "Syrie");
    namesMap.put("TC", "Îles Turques-et-Caïques");
    namesMap.put("TD", "Tchad");
    namesMap.put("TF", "Terres australes françaises");
    namesMap.put("TH", "Thaïlande");
    namesMap.put("TJ", "Tadjikistan");
    namesMap.put("TL", "Timor oriental");
    namesMap.put("TM", "Turkménistan");
    namesMap.put("TN", "Tunisie");
    namesMap.put("TR", "Turquie");
    namesMap.put("TT", "Trinité-et-Tobago");
    namesMap.put("TW", "Taïwan");
    namesMap.put("TZ", "Tanzanie");
    namesMap.put("UG", "Ouganda");
    namesMap.put("UM", "Îles mineures éloignées des États-Unis");
    namesMap.put("UN", "Nations Unies");
    namesMap.put("US", "États-Unis");
    namesMap.put("UZ", "Ouzbékistan");
    namesMap.put("VA", "État de la Cité du Vatican");
    namesMap.put("VC", "Saint-Vincent-et-les-Grenadines");
    namesMap.put("VG", "Îles Vierges britanniques");
    namesMap.put("VI", "Îles Vierges des États-Unis");
    namesMap.put("WF", "Wallis-et-Futuna");
    namesMap.put("YE", "Yémen");
    namesMap.put("ZA", "Afrique du Sud");
    namesMap.put("ZM", "Zambie");
    namesMap.put("ZZ", "région indéterminée");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Monde",
        "002": "Afrique",
        "003": "Amérique du Nord",
        "005": "Amérique du Sud",
        "009": "Océanie",
        "011": "Afrique occidentale",
        "013": "Amérique centrale",
        "014": "Afrique orientale",
        "015": "Afrique septentrionale",
        "017": "Afrique centrale",
        "018": "Afrique australe",
        "019": "Amériques",
        "021": "Amérique septentrionale",
        "029": "Caraïbes",
        "030": "Asie de l’Est",
        "034": "Asie du Sud",
        "035": "Asie du Sud-Est",
        "039": "Europe du Sud",
        "053": "Australasie",
        "054": "Mélanésie",
        "057": "région micronésienne",
        "061": "Polynésie",
        "142": "Asie",
        "143": "Asie centrale",
        "145": "Asie de l’Ouest",
        "151": "Europe de l’Est",
        "154": "Europe du Nord",
        "155": "Europe de l’Ouest",
        "202": "Afrique subsaharienne",
        "419": "Amérique latine",
        "AC": "Île de l’Ascension",
        "AD": "Andorre",
        "AE": "Émirats arabes unis",
        "AG": "Antigua-et-Barbuda",
        "AL": "Albanie",
        "AM": "Arménie",
        "AQ": "Antarctique",
        "AR": "Argentine",
        "AS": "Samoa américaines",
        "AT": "Autriche",
        "AU": "Australie",
        "AX": "Îles Åland",
        "AZ": "Azerbaïdjan",
        "BA": "Bosnie-Herzégovine",
        "BB": "Barbade",
        "BE": "Belgique",
        "BG": "Bulgarie",
        "BH": "Bahreïn",
        "BJ": "Bénin",
        "BL": "Saint-Barthélemy",
        "BM": "Bermudes",
        "BN": "Brunéi Darussalam",
        "BO": "Bolivie",
        "BQ": "Pays-Bas caribéens",
        "BR": "Brésil",
        "BT": "Bhoutan",
        "BV": "Île Bouvet",
        "BY": "Biélorussie",
        "CC": "Îles Cocos",
        "CD": "Congo-Kinshasa",
        "CF": "République centrafricaine",
        "CG": "Congo-Brazzaville",
        "CH": "Suisse",
        "CK": "Îles Cook",
        "CL": "Chili",
        "CM": "Cameroun",
        "CN": "Chine",
        "CO": "Colombie",
        "CP": "Île Clipperton",
        "CV": "Cap-Vert",
        "CX": "Île Christmas",
        "CY": "Chypre",
        "CZ": "Tchéquie",
        "DE": "Allemagne",
        "DK": "Danemark",
        "DM": "Dominique",
        "DO": "République dominicaine",
        "DZ": "Algérie",
        "EA": "Ceuta et Melilla",
        "EC": "Équateur",
        "EE": "Estonie",
        "EG": "Égypte",
        "EH": "Sahara occidental",
        "ER": "Érythrée",
        "ES": "Espagne",
        "ET": "Éthiopie",
        "EU": "Union européenne",
        "EZ": "zone euro",
        "FI": "Finlande",
        "FJ": "Fidji",
        "FK": "Îles Malouines",
        "FM": "États fédérés de Micronésie",
        "FO": "Îles Féroé",
        "GB": "Royaume-Uni",
        "GD": "Grenade",
        "GE": "Géorgie",
        "GF": "Guyane française",
        "GG": "Guernesey",
        "GL": "Groenland",
        "GM": "Gambie",
        "GN": "Guinée",
        "GQ": "Guinée équatoriale",
        "GR": "Grèce",
        "GS": "Géorgie du Sud et îles Sandwich du Sud",
        "GW": "Guinée-Bissau",
        "HK": "R.A.S. chinoise de Hong Kong",
        "HM": "Îles Heard et McDonald",
        "HR": "Croatie",
        "HT": "Haïti",
        "HU": "Hongrie",
        "IC": "Îles Canaries",
        "ID": "Indonésie",
        "IE": "Irlande",
        "IL": "Israël",
        "IM": "Île de Man",
        "IN": "Inde",
        "IO": "Territoire britannique de l’océan Indien",
        "IQ": "Irak",
        "IS": "Islande",
        "IT": "Italie",
        "JM": "Jamaïque",
        "JO": "Jordanie",
        "JP": "Japon",
        "KG": "Kirghizistan",
        "KH": "Cambodge",
        "KM": "Comores",
        "KN": "Saint-Christophe-et-Niévès",
        "KP": "Corée du Nord",
        "KR": "Corée du Sud",
        "KW": "Koweït",
        "KY": "Îles Caïmans",
        "LB": "Liban",
        "LC": "Sainte-Lucie",
        "LR": "Libéria",
        "LT": "Lituanie",
        "LV": "Lettonie",
        "LY": "Libye",
        "MA": "Maroc",
        "MD": "Moldavie",
        "ME": "Monténégro",
        "MF": "Saint-Martin",
        "MH": "Îles Marshall",
        "MK": "Macédoine",
        "MM": "Myanmar (Birmanie)",
        "MN": "Mongolie",
        "MO": "R.A.S. chinoise de Macao",
        "MP": "Îles Mariannes du Nord",
        "MR": "Mauritanie",
        "MT": "Malte",
        "MU": "Maurice",
        "MX": "Mexique",
        "MY": "Malaisie",
        "NA": "Namibie",
        "NC": "Nouvelle-Calédonie",
        "NF": "Île Norfolk",
        "NG": "Nigéria",
        "NL": "Pays-Bas",
        "NO": "Norvège",
        "NP": "Népal",
        "NZ": "Nouvelle-Zélande",
        "PE": "Pérou",
        "PF": "Polynésie française",
        "PG": "Papouasie-Nouvelle-Guinée",
        "PL": "Pologne",
        "PM": "Saint-Pierre-et-Miquelon",
        "PN": "Îles Pitcairn",
        "PR": "Porto Rico",
        "PS": "Territoires palestiniens",
        "PW": "Palaos",
        "QO": "régions éloignées de l’Océanie",
        "RE": "La Réunion",
        "RO": "Roumanie",
        "RS": "Serbie",
        "RU": "Russie",
        "SA": "Arabie saoudite",
        "SB": "Îles Salomon",
        "SD": "Soudan",
        "SE": "Suède",
        "SG": "Singapour",
        "SH": "Sainte-Hélène",
        "SI": "Slovénie",
        "SJ": "Svalbard et Jan Mayen",
        "SK": "Slovaquie",
        "SM": "Saint-Marin",
        "SN": "Sénégal",
        "SO": "Somalie",
        "SS": "Soudan du Sud",
        "ST": "Sao Tomé-et-Principe",
        "SV": "Salvador",
        "SX": "Saint-Martin (partie néerlandaise)",
        "SY": "Syrie",
        "TC": "Îles Turques-et-Caïques",
        "TD": "Tchad",
        "TF": "Terres australes françaises",
        "TH": "Thaïlande",
        "TJ": "Tadjikistan",
        "TL": "Timor oriental",
        "TM": "Turkménistan",
        "TN": "Tunisie",
        "TR": "Turquie",
        "TT": "Trinité-et-Tobago",
        "TW": "Taïwan",
        "TZ": "Tanzanie",
        "UG": "Ouganda",
        "UM": "Îles mineures éloignées des États-Unis",
        "UN": "Nations Unies",
        "US": "États-Unis",
        "UZ": "Ouzbékistan",
        "VA": "État de la Cité du Vatican",
        "VC": "Saint-Vincent-et-les-Grenadines",
        "VG": "Îles Vierges britanniques",
        "VI": "Îles Vierges des États-Unis",
        "WF": "Wallis-et-Futuna",
        "YE": "Yémen",
        "ZA": "Afrique du Sud",
        "ZM": "Zambie",
        "ZZ": "région indéterminée"
    };
  }-*/;
}
