/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface ReadonlyMap<KEY, VALUE>
    extends JsIterable<JsArray<ReadonlyMap.JsIterableTypeParameterArrayUnionType<KEY, VALUE>>> {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface EntriesJsIteratorIterableTypeParameterArrayUnionType<KEY, VALUE> {
    @JsOverlay
    static ReadonlyMap.EntriesJsIteratorIterableTypeParameterArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default KEY asKEY() {
      return Js.cast(this);
    }

    @JsOverlay
    default VALUE asVALUE() {
      return Js.cast(this);
    }
  }

  @JsFunction
  public interface ForEachCallbackFn<KEY, VALUE> {
    Object onInvoke(VALUE p0, KEY p1);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface JsIterableTypeParameterArrayUnionType<KEY, VALUE> {
    @JsOverlay
    static ReadonlyMap.JsIterableTypeParameterArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default KEY asKEY() {
      return Js.cast(this);
    }

    @JsOverlay
    default VALUE asVALUE() {
      return Js.cast(this);
    }
  }

  JsIteratorIterable<
          JsArray<ReadonlyMap.EntriesJsIteratorIterableTypeParameterArrayUnionType<KEY, VALUE>>>
      entries();

  <THIS> void forEach(
      ReadonlyMap.ForEachCallbackFn<? super KEY, ? super VALUE> callback, THIS thisArg);

  void forEach(ReadonlyMap.ForEachCallbackFn<? super KEY, ? super VALUE> callback);

  VALUE get(KEY key);

  @JsProperty
  double getSize();

  boolean has(KEY key);

  JsIteratorIterable<KEY> keys();

  JsIteratorIterable<VALUE> values();
}
