/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.media.client;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.MediaElement;
import com.google.gwt.dom.client.SourceElement;
import com.google.gwt.event.dom.client.CanPlayThroughEvent;
import com.google.gwt.event.dom.client.CanPlayThroughHandler;
import com.google.gwt.event.dom.client.EndedEvent;
import com.google.gwt.event.dom.client.EndedHandler;
import com.google.gwt.event.dom.client.HasAllMediaHandlers;
import com.google.gwt.event.dom.client.LoadedMetadataEvent;
import com.google.gwt.event.dom.client.LoadedMetadataHandler;
import com.google.gwt.event.dom.client.ProgressEvent;
import com.google.gwt.event.dom.client.ProgressHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.media.dom.client.MediaError;
import com.google.gwt.media.dom.client.TimeRanges;
import com.google.gwt.user.client.ui.FocusWidget;

public abstract class MediaBase
extends FocusWidget
implements HasAllMediaHandlers {
    protected MediaBase(MediaElement element) {
        this.setElement(element);
    }

    @Override
    public HandlerRegistration addCanPlayThroughHandler(CanPlayThroughHandler handler) {
        return this.addBitlessDomHandler(handler, CanPlayThroughEvent.getType());
    }

    @Override
    public HandlerRegistration addEndedHandler(EndedHandler handler) {
        return this.addBitlessDomHandler(handler, EndedEvent.getType());
    }

    @Override
    public HandlerRegistration addProgressHandler(ProgressHandler handler) {
        return this.addBitlessDomHandler(handler, ProgressEvent.getType());
    }

    @Override
    public HandlerRegistration addLoadedMetadataHandler(LoadedMetadataHandler handler) {
        return this.addBitlessDomHandler(handler, LoadedMetadataEvent.getType());
    }

    public SourceElement addSource(String url) {
        SourceElement elem = Document.get().createSourceElement();
        elem.setSrc(url);
        this.getElement().appendChild(elem);
        return elem;
    }

    public SourceElement addSource(String url, String type) {
        SourceElement elem = this.addSource(url);
        elem.setType(type);
        return elem;
    }

    public String canPlayType(String type) {
        return this.getMediaElement().canPlayType(type);
    }

    public TimeRanges getBuffered() {
        return this.getMediaElement().getBuffered();
    }

    public String getCurrentSrc() {
        return this.getMediaElement().getCurrentSrc();
    }

    public double getCurrentTime() {
        return this.getMediaElement().getCurrentTime();
    }

    public double getDefaultPlaybackRate() {
        return this.getMediaElement().getDefaultPlaybackRate();
    }

    public double getDuration() {
        return this.getMediaElement().getDuration();
    }

    public MediaError getError() {
        return this.getMediaElement().getError();
    }

    public double getInitialTime() {
        return this.getMediaElement().getInitialTime();
    }

    public MediaElement getMediaElement() {
        return (MediaElement)this.getElement().cast();
    }

    public int getNetworkState() {
        return this.getMediaElement().getNetworkState();
    }

    public double getPlaybackRate() {
        return this.getMediaElement().getPlaybackRate();
    }

    public TimeRanges getPlayed() {
        return this.getMediaElement().getPlayed();
    }

    public String getPreload() {
        return this.getMediaElement().getPreload();
    }

    public int getReadyState() {
        return this.getMediaElement().getReadyState();
    }

    public TimeRanges getSeekable() {
        return this.getMediaElement().getSeekable();
    }

    public String getSrc() {
        return this.getMediaElement().getSrc();
    }

    public double getStartOffsetTime() {
        return this.getMediaElement().getStartOffsetTime();
    }

    public double getVolume() {
        return this.getMediaElement().getVolume();
    }

    public boolean hasControls() {
        return this.getMediaElement().hasControls();
    }

    public boolean hasEnded() {
        return this.getMediaElement().hasEnded();
    }

    public boolean isAutoplay() {
        return this.getMediaElement().isAutoplay();
    }

    public boolean isLoop() {
        return this.getMediaElement().isLoop();
    }

    public boolean isMuted() {
        return this.getMediaElement().isMuted();
    }

    public boolean isPaused() {
        return this.getMediaElement().isPaused();
    }

    public boolean isSeeking() {
        return this.getMediaElement().isSeeking();
    }

    public void load() {
        this.getMediaElement().load();
    }

    public void pause() {
        this.getMediaElement().pause();
    }

    public void play() {
        this.getMediaElement().play();
    }

    public void removeSource(SourceElement source) {
        this.getElement().removeChild(source);
    }

    public void setAutoplay(boolean autoplay) {
        this.getMediaElement().setAutoplay(autoplay);
    }

    public void setControls(boolean controls) {
        this.getMediaElement().setControls(controls);
    }

    public void setCurrentTime(double time) {
        this.getMediaElement().setCurrentTime(time);
    }

    public void setDefaultPlaybackRate(double rate) {
        this.getMediaElement().setDefaultPlaybackRate(rate);
    }

    public final void setLoop(boolean loop) {
        this.getMediaElement().setLoop(loop);
    }

    public void setMuted(boolean muted) {
        this.getMediaElement().setMuted(muted);
    }

    public void setPlaybackRate(double rate) {
        this.getMediaElement().setPlaybackRate(rate);
    }

    public void setPreload(String preload) {
        this.getMediaElement().setPreload(preload);
    }

    public void setSrc(String url) {
        this.getMediaElement().setSrc(url);
    }

    public void setVolume(double volume) {
        this.getMediaElement().setVolume(volume);
    }
}

