/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.LocalizableResource;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.server.KeyGenerator;
import com.google.gwt.i18n.server.Message;
import com.google.gwt.i18n.server.MessageFormatUtils;
import com.google.gwt.i18n.server.MessageInterface;
import com.google.gwt.i18n.server.MessageProcessingException;
import com.google.gwt.i18n.server.MessageTranslation;
import com.google.gwt.i18n.server.MessageUtils;
import com.google.gwt.i18n.server.MessageVisitor;
import com.google.gwt.i18n.server.Parameter;
import com.google.gwt.i18n.server.StringMapMessageTranslation;
import com.google.gwt.i18n.server.Type;
import com.google.gwt.i18n.shared.AlternateMessageSelector;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractMessage
implements Message {
    private List<AlternateMessageSelector.AlternateForm> defaultForms;
    private String defaultMessage;
    private boolean isStringMap;
    private String key = null;
    private final GwtLocaleFactory localeFactory;
    private GwtLocale matchedLocale;
    private String meaning;
    private final MessageInterface msgIntf;
    private MessageFormatUtils.MessageStyle messageStyle;
    private AlternateMessageSelector[] selectors;
    private int[] selectorParams;
    private MessageTranslation overrideDefault;

    public AbstractMessage(GwtLocaleFactory localeFactory, MessageInterface msgIntf) {
        this.localeFactory = localeFactory;
        this.msgIntf = msgIntf;
    }

    @Override
    public void accept(MessageVisitor mv) throws MessageProcessingException {
        this.accept(mv, null);
    }

    @Override
    public void accept(MessageVisitor mv, GwtLocale locale) throws MessageProcessingException {
        this.ensureSelectorParams();
        List<Parameter> params = this.getParameters();
        int numSelectors = this.selectorParams.length;
        String[] lastForm = new String[numSelectors];
        MessageTranslation trans = null;
        if (locale != null) {
            GwtLocale search;
            Iterator<Comparable<GwtLocale>> iterator = locale.getCompleteSearchList().iterator();
            while (iterator.hasNext() && (trans = this.getTranslation(search = (GwtLocale)iterator.next())) == null) {
            }
        }
        if (trans == null) {
            trans = this;
        }
        for (Message.AlternateFormMapping mapping : trans.getAllMessageForms()) {
            List<AlternateMessageSelector.AlternateForm> forms = mapping.getForms();
            boolean allOther = true;
            for (int i = 0; i < forms.size(); ++i) {
                lastForm[i] = forms.get(i).getName();
                if ("other".equals(lastForm[i])) continue;
                allOther = false;
            }
            mv.visitTranslation(lastForm, allOther, this.messageStyle, mapping.getMessage());
        }
        mv.endMessage(this, trans);
    }

    @Override
    public int compareTo(Message o) {
        return this.getKey().compareTo(o.getKey());
    }

    @Override
    public Iterable<Message.AlternateFormMapping> getAllMessageForms() {
        if (this.overrideDefault != null) {
            return this.overrideDefault.getAllMessageForms();
        }
        ArrayList<Message.AlternateFormMapping> mapping = new ArrayList<Message.AlternateFormMapping>();
        List<Parameter> params = this.getParameters();
        int[] selectorIndices = this.getSelectorParameterIndices();
        int numSelectors = selectorIndices.length;
        if (!this.isStringMap) {
            mapping.add(new Message.AlternateFormMapping(this.defaultForms, this.getDefaultMessage()));
        }
        String[] altMessages = null;
        if (this.isStringMap) {
            Constants.DefaultStringMapValue smv = this.getAnnotation(Constants.DefaultStringMapValue.class);
            if (smv != null) {
                altMessages = smv.value();
            }
        } else {
            altMessages = this.getAlternateMessages();
        }
        if (altMessages == null) {
            return mapping;
        }
        int n = altMessages.length;
        for (int msgIdx = 0; msgIdx < n; msgIdx += 2) {
            this.addMapping(mapping, numSelectors, altMessages[msgIdx], altMessages[msgIdx + 1]);
        }
        Collections.sort(mapping);
        return mapping;
    }

    @Override
    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    @Override
    public String getDefaultMessage() {
        if (this.overrideDefault != null) {
            return this.overrideDefault.getDefaultMessage();
        }
        return this.defaultMessage;
    }

    @Override
    public String getDescription() {
        LocalizableResource.Description descAnnot = this.getAnnotation(LocalizableResource.Description.class);
        if (descAnnot != null) {
            return descAnnot.value();
        }
        return null;
    }

    @Override
    public String getKey() {
        MessageUtils.KeyGeneratorException keyGenException = null;
        if (this.key == null) {
            LocalizableResource.Key keyAnnot = this.getAnnotation(LocalizableResource.Key.class);
            if (keyAnnot != null) {
                this.key = keyAnnot.value();
            } else {
                LocalizableResource.GenerateKeys keyGenAnnot = this.getAnnotation(LocalizableResource.GenerateKeys.class);
                try {
                    KeyGenerator keyGen = MessageUtils.getKeyGenerator(keyGenAnnot);
                    this.key = keyGen.generateKey(this);
                }
                catch (MessageUtils.KeyGeneratorException e) {
                    keyGenException = e;
                }
            }
        }
        if (this.key == null) {
            LocalizableResource.GenerateKeys keyGenAnnot = this.getAnnotation(LocalizableResource.GenerateKeys.class);
            throw new RuntimeException("null key on " + this.getMessageInterface().getQualifiedName() + "." + this.getMethodName() + ", @GenerateKeys=" + keyGenAnnot + ", defmsg=" + this.defaultMessage + ", meaning=" + this.meaning + ", @DefaultMessage=" + this.getAnnotation(Messages.DefaultMessage.class) + ", @Meaning=" + this.getAnnotation(LocalizableResource.Meaning.class) + ", override=" + this.overrideDefault, keyGenException);
        }
        return this.key;
    }

    @Override
    public GwtLocale getMatchedLocale() {
        if (this.overrideDefault != null) {
            return this.overrideDefault.getMatchedLocale();
        }
        return this.matchedLocale;
    }

    @Override
    public String getMeaning() {
        return this.meaning;
    }

    @Override
    public MessageInterface getMessageInterface() {
        return this.msgIntf;
    }

    @Override
    public MessageFormatUtils.MessageStyle getMessageStyle() {
        return this.messageStyle;
    }

    @Override
    public abstract String getMethodName();

    @Override
    public abstract List<Parameter> getParameters();

    @Override
    public abstract Type getReturnType();

    @Override
    public int[] getSelectorParameterIndices() {
        if (this.selectorParams == null) {
            this.ensureSelectorParams();
        }
        return this.selectorParams;
    }

    @Override
    public abstract MessageTranslation getTranslation(GwtLocale var1);

    @Override
    public abstract boolean isAnnotationPresent(Class<? extends Annotation> var1);

    protected void addMapping(List<Message.AlternateFormMapping> mapping, int numSelectors, String joinedForms, String msg) {
        String[] formNames = joinedForms.split("\\|");
        if (formNames.length != numSelectors) {
            return;
        }
        ArrayList<AlternateMessageSelector.AlternateForm> forms = new ArrayList<AlternateMessageSelector.AlternateForm>();
        boolean nonOther = false;
        for (int selIdx = 0; selIdx < numSelectors; ++selIdx) {
            String formName = formNames[selIdx];
            if (!this.selectors[selIdx].isFormAcceptable(formName)) {
                nonOther = false;
                break;
            }
            if (this.isStringMap || !"other".equals(formName)) {
                nonOther = true;
            }
            forms.add(new AlternateMessageSelector.AlternateForm(formName, formName));
        }
        if (nonOther) {
            mapping.add(new Message.AlternateFormMapping(forms, msg));
        }
    }

    protected List<AlternateMessageSelector.AlternateForm> defaultForms() {
        return this.defaultForms;
    }

    protected String[] getAlternateMessages() {
        Messages.AlternateMessage altMsgAnnot = this.getAnnotation(Messages.AlternateMessage.class);
        if (altMsgAnnot != null) {
            return altMsgAnnot.value();
        }
        Messages.PluralText pluralTextAnnot = this.getAnnotation(Messages.PluralText.class);
        if (pluralTextAnnot != null) {
            return pluralTextAnnot.value();
        }
        return null;
    }

    protected GwtLocale getDefaultLocale() {
        LocalizableResource.DefaultLocale defLocaleAnnot = this.getAnnotation(LocalizableResource.DefaultLocale.class);
        String defLocale = defLocaleAnnot != null ? defLocaleAnnot.value() : "en";
        return this.localeFactory.fromString(defLocale);
    }

    protected GwtLocaleFactory getLocaleFactory() {
        return this.localeFactory;
    }

    protected void init() {
        this.matchedLocale = this.getDefaultLocale();
        if (this.isAnnotationPresent(Messages.DefaultMessage.class)) {
            this.messageStyle = MessageFormatUtils.MessageStyle.MESSAGE_FORMAT;
            Messages.DefaultMessage defMsgAnnot = this.getAnnotation(Messages.DefaultMessage.class);
            this.defaultMessage = defMsgAnnot.value();
        } else if (this.isAnnotationPresent(Constants.DefaultStringMapValue.class)) {
            this.messageStyle = MessageFormatUtils.MessageStyle.PLAIN;
            this.processStringMap(this.getAnnotation(Constants.DefaultStringMapValue.class));
            this.isStringMap = true;
        } else {
            this.messageStyle = MessageFormatUtils.MessageStyle.PLAIN;
            this.defaultMessage = MessageUtils.getConstantsDefaultValue(this);
        }
        LocalizableResource.Meaning meaningAnnot = this.getAnnotation(LocalizableResource.Meaning.class);
        this.meaning = meaningAnnot != null ? meaningAnnot.value() : null;
        if (this.overrideDefault == null) {
            this.overrideDefault = this.getTranslation(this.localeFactory.getDefault());
            if (this.overrideDefault == this) {
                this.overrideDefault = null;
            }
        }
        List<Parameter> params = this.getParameters();
        int[] selectorIndices = this.getSelectorParameterIndices();
        int numSelectors = selectorIndices.length;
        this.defaultForms = new ArrayList<AlternateMessageSelector.AlternateForm>();
        this.selectors = new AlternateMessageSelector[numSelectors];
        for (int i = 0; i < numSelectors; ++i) {
            int selIdx = selectorIndices[i];
            if (selIdx < 0) {
                this.selectors[i] = new AlternateMessageSelector(){

                    @Override
                    public boolean isFormAcceptable(String form) {
                        return true;
                    }
                };
                continue;
            }
            this.selectors[i] = params.get(selIdx).getAlternateMessageSelector();
            this.defaultForms.add(AlternateMessageSelector.OTHER_FORM);
        }
    }

    protected boolean isStringMap() {
        return this.isStringMap;
    }

    private void ensureSelectorParams() {
        int i;
        if (this.isAnnotationPresent(Constants.DefaultStringMapValue.class)) {
            this.selectorParams = new int[]{-1};
            return;
        }
        ArrayList<Integer> selectorIdx = new ArrayList<Integer>();
        List<Parameter> params = this.getParameters();
        int n = params.size();
        for (i = 0; i < n; ++i) {
            Parameter param = params.get(i);
            if (!param.isAnnotationPresent(Messages.PluralCount.class) && !param.isAnnotationPresent(Messages.Select.class)) continue;
            selectorIdx.add(i);
        }
        n = selectorIdx.size();
        this.selectorParams = new int[n];
        for (i = 0; i < n; ++i) {
            this.selectorParams[i] = (Integer)selectorIdx.get(i);
        }
    }

    private void processStringMap(Constants.DefaultStringMapValue dsmv) {
        String[] keyValues = dsmv.value();
        StringBuilder buf = new StringBuilder();
        boolean needComma = false;
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> sortedKeys = new ArrayList<String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            sortedKeys.add(keyValues[i]);
            map.put(keyValues[i], keyValues[i + 1]);
            if (needComma) {
                buf.append(',');
            } else {
                needComma = true;
            }
            buf.append(MessageUtils.quoteComma(keyValues[i]));
        }
        this.defaultMessage = buf.toString();
        Collections.sort(sortedKeys);
        this.overrideDefault = new StringMapMessageTranslation(this.defaultMessage, sortedKeys, map, this.matchedLocale);
    }
}

